// Stehende Lngswellen
// Java-Applet (08.06.1998) umgewandelt
// 07.10.2014 - 14.09.2015

// ****************************************************************************
// * Autor: Walter Fendt (www.walter-fendt.de)                                *
// * Dieses Programm darf - auch in vernderter Form - fr nicht-kommerzielle *
// * Zwecke verwendet und weitergegeben werden, solange dieser Hinweis nicht  *
// * entfernt wird.                                                           *
// **************************************************************************** 

// Sprachabhngige Texte sind einer eigenen Datei (zum Beispiel standinglongitudinalwaves_de.js) abgespeichert.

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe
var colorElongation = "#ff0000";                           // Farbe fr Elongation
var colorPressure = "#ff00ff";                             // Farbe fr Druck
var colorParticle = "#0000ff";                             // Farbe der Teilchen

// Sonstige Konstanten:

var cReal = 343.5;                                         // Schallgeschwindigkeit real (20 C, m/s)
var c = 2000;                                              // Schallgeschwindigkeit der Animation (Pixel/s)
var length = 300;                                          // Rohrlnge (Pixel)
var left = 60;                                             // Abstand vom linken Rand (Pixel)

// Attribute:

var canvas, ctx;                                           // Zeichenflche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenflche (Pixel)
var rboo, rbco, rbcc;                                      // Radiobuttons (Rohrtyp)
var lbosc;                                                 // Ausgabefeld fr Bezeichnung der Eigenschwingung
var bu1, bu2;                                              // Schaltknpfe (Tiefer, Hher)
var ipl;                                                   // Eingabefeld (Rohrlnge)
var opwl, opfr;                                            // Ausgabefelder (Wellenlnge, Frequenz)
var t0;                                                    // Bezugszeitpunkt
var t;                                                     // Aktuelle Zeit (s)
var type;                                                  // Rohrtyp (0,1,2)
var nrOsc;                                                 // Nummer der Eigenschwingung
var lengthReal;                                            // Rohrlnge real (m)
var lambdaReal;                                            // Wellenlnge (m)
var lambda;                                                // Wellenlnge (Pixel)
var lambda4;                                               // Abkrzung fr lambda/4
var nyReal;                                                // Frequenz real (Hz)
var omega;                                                 // Kreisfrequenz der Animation (1/s)
var k;                                                     // Wellenzahl (1/Pixel)
var aMax;                                                  // Maximale Amplitude (Pixel)
var cos;                                                   // cos(omega*t)
var xT, yT;                                                // Koordinaten (spezielles Teilchen)

// Element der Schaltflche (aus HTML-Datei):
// id ..... ID im HTML-Befehl
// text ... Text (optional)

function getElement (id, text) {
  var e = document.getElementById(id);                     // Element
  if (text) e.innerHTML = text;                            // Text festlegen, falls definiert
  return e;                                                // Rckgabewert
  } 

// Start:

function start () {
  canvas = getElement("cv");                               // Zeichenflche
  width = canvas.width; height = canvas.height;            // Abmessungen (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  getElement("form",text01);                               // Erklrender Text (Rohrform)
  rboo = getElement("rboo");                               // Radiobutton (beidseitig offen)
  getElement("lboo",text02);                               // Erklrender Text (beidseitig offen)
  rboo.checked = true;                                     // Radiobutton ausgewhlt
  rbco = getElement("rbco");                               // Radiobutton (einseitig offen)
  getElement("lbco",text03);                               // Erklrender Text (einseitig offen)
  rbcc = getElement("rbcc");                               // Radiobutton (beidseitig geschlossen)
  getElement("lbcc",text04);                               // Erklrender Text (beidseitg geschlossen)
  getElement("harmonic",text05);                           // Erklrender Text (Eigenschwingung)
  lbosc = getElement("lbosc");                             // Ausgabefeld (Bezeichnung der Eigenschwingung)
  bu1 = getElement("bu1",text07);                          // Schaltknopf (Tiefer)
  bu2 = getElement("bu2",text08);                          // Schaltknopf (Hher)
  getElement("ipLa",text09);                               // Erklrender Text (Rohrlnge)
  ipl = getElement("ipLb");                                // Eingabefeld (Rohrlnge)
  getElement("ipLc",meter);                                // Einheit (Rohrlnge)
  getElement("opWa",text10);                               // Erklrender Text (Wellenlnge)
  opwl = getElement("opWb");                               // Ausgabefeld (Wellenlnge)
  getElement("opWc",meter);                                // Einheit (Wellenlnge)
  getElement("opFa",text11);                               // Erklrender Text (Frequenz)
  opfr = getElement("opFb");                               // Ausgabefeld (Frequenz)
  getElement("opFc",hertz);                                // Einheit (Frequenz)
  getElement("author",author);                             // Autor
  
  type = 0;                                                // Anfangswert fr Rohrtyp (beidseitig offen)
  nrOsc = 0;                                               // Anfangswert fr Nummer der Eigenschwingung (Grundschwingung)
  lengthReal = 1;                                          // Anfangswert fr Rohrlnge (m)
  t = 0;                                                   // Anfangswert fr Zeitvariable
  t0 = new Date();                                         // Bezugszeitpunkt
  ipl.value = ToString(lengthReal,3,false);                // Eingabefeld (Rohrlnge) aktualisieren
  newOscillation();                                        // Schaltknopf "Tiefer" deaktivieren, Berechnungen
  setInterval(paint,40);                                   // Timer-Intervall 0,040 s
  
  rboo.onclick = reactionRadioButton;                      // Reaktion auf Radiobutton "beidseitig offen"
  rbco.onclick = reactionRadioButton;                      // Reaktion auf Radiobutton "einseitig offen"
  rbcc.onclick = reactionRadioButton;                      // Reaktion auf Radiobutton "beidseitig geschlossen"
  bu1.onclick = reactionLower;                             // Reaktion auf Schaltknopf "Tiefer"
  bu2.onclick = reactionHigher;                            // Reaktion auf Schaltknopf "Hher"
  ipl.onkeydown = reactionEnter;                           // Reaktion auf Enter-Taste (Eingabefeld fr Rohrlnge)
  
  canvas.onmousedown = function (e) {                      // Reaktion auf Drcken der Maustaste
    reactionDown(e.clientX,e.clientY);                     // Aufruf der gemeinsamen Methode                     
    }
    
  canvas.ontouchstart = function (e) {                     // Reaktion auf Berhrung
    var obj = e.changedTouches[0];
    reactionDown(obj.clientX,obj.clientY);                 // Aufruf der gemeinsamen Methode
    }
    
  } // Ende der Methode start
  
// Reaktion auf Anklicken eines Radiobuttons:
// Seiteneffekt type, lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT

function reactionRadioButton () {
  if (rboo.checked) type = 0;                              // Wert fr beidseitig offenes Rohr                  
  else if (rbco.checked) type = 1;                         // Wert fr einseitig offenes Rohr
  else type = 2;                                           // Wert fr beidseitg geschlossenes Rohr
  reaction();                                              // Eingegebenen Wert bernehmen, Berechnungen
  }
  
// Reaktion auf Anklicken des Schaltknopfs "Tiefer":
// Seiteneffekt nrOsc, lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT

function reactionLower () {
  if (nrOsc < 1) return;                                   // Falls Grundschwingung, abbrechen
  nrOsc--;                                                 // Nummer der Eigenschwingung erniedrigen
  newOscillation();                                        // Eingabe, Schaltknpfe (de-)aktivieren, Berechnungen, Ausgabe
  }
  
// Reaktion auf Anklicken des Schaltknopfs "Hher":
// Seiteneffekt nrOsc, lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT

function reactionHigher () {
  if (nrOsc > 4) return;                                   // Falls 5. Oberschwingung, abbrechen
  nrOsc++;                                                 // Nummer der Eigenschwingung erhhen
  newOscillation();                                        // Eingabe, Schalknpfe (de-)aktivieren, Berechnungen, Ausgabe
  }
  
// Hilfsroutine: Eingabe bernehmen, rechnen, Ausgabefelder aktualisieren
// Seiteneffekt lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT 

function reaction () {
  input();                                                 // Eingegebene Werte bernehmen (eventuell korrigiert)
  calculation();                                           // Berechnungen, Ausgabefelder aktualisieren
  }
  
// Reaktion auf Tastendruck (nur auf Enter-Taste):
// Seiteneffekt lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT
  
function reactionEnter (e) {
  if (e.key && String(e.key) == "Enter"                    // Falls Entertaste (Firefox/Internet Explorer) ...
  || e.keyCode == 13)                                      // Falls Entertaste (Chrome) ...
    reaction();                                            // ... Daten bernehmen, rechnen, Ausgabe aktualisieren
  }
  
// Reaktion auf Mausklick oder Berhren mit dem Finger (Auswahl):
// x, y ... Bildschirmkoordinaten bezglich Viewport
// Seiteneffekt xT, yT

function reactionDown (x, y) {
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  x -= re.left; y -= re.top;                               // Koordinaten bezglich Zeichenflche
  if (x >= left && x <= left+length && y >= 30 && y <= 90) // Falls Position im Bereich des Rohrs ... 
    {xT = x; yT = y;}                                      // ... Koordinaten des besonderen Teilchens festlegen,
  else xT = yT = -1;                                       // ... andernfalls negative (sinnlose) Koordinaten festlegen 
  }
   
//-------------------------------------------------------------------------------------------------

// Neue Eigenschwingung:
// Eingabe bernehmen, Ausgabefelder aktualisieren, Schaltknpfe aktivieren bzw. deaktivieren
// Seiteneffekt lengthReal, lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT

function newOscillation () {
  input();
  lbosc.innerHTML = text06[nrOsc];                         // Ausgabefeld fr Eigenschwingung aktualisieren
  bu1.disabled = (nrOsc < 1);                              // Schaltknopf "Tiefer" aktivieren oder deaktivieren
  bu2.disabled = (nrOsc > 4);                              // Schaltknopf "Hher" aktivieren oder deaktivieren
  calculation();                                           // Berechnungen, Ausgabefelder aktualisieren
  }

// Berechnungen, Aktualisierung der Ausgabefelder fr Wellenlnge und Frequenz:
// Seiteneffekt lambdaReal, lambda, lambda4, omega, k, nyReal, aMax, xT, yT

function calculation () {
  var factor = (type==1 ? 4.0/(2*nrOsc+1) : 2.0/(nrOsc+1));// Faktor fr Wellenlnge
  lambdaReal = factor*lengthReal;                          // Reale Wellenlnge (m)
  lambda = factor*length;                                  // Wellenlnge (Pixel)
  lambda4 = lambda/4;                                      // Viertel der Wellenlnge (Pixel)
  omega = c/(lambda*2*Math.PI);                            // Kreisfrequenz der Animation (1/s) 
  k = 2*Math.PI/lambda;                                    // Wellenzahl (1/Pixel)
  nyReal = cReal/lambdaReal;                               // Reale Frequenz (Hz)
  var s = lambdaReal.toPrecision(3);                       // Zeichenkette fr Wellenlnge (m)
  opwl.innerHTML = s.replace(".",decimalSeparator);        // Ausgabefeld fr Wellenlnge aktualisieren
  if (nyReal < 1000) s = nyReal.toPrecision(3);            // Zeichenkette fr Frequenz (Hz) entweder mit 3 gltigen Ziffern ...
  else s = nyReal.toFixed(0);                              // ... oder auf eine ganze Zahl gerundet
  opfr.innerHTML = s.replace(".",decimalSeparator);        // Ausgabefeld fr Frequenz aktualisieren
  aMax = lambda/24;                                        // Maximale Amplitude (Pixel)
  xT = yT = -1;                                            // Sinnlose Koordinaten fr besonderes Teilchen
  }
  
// Berechnung der momentanen Position eines Teilchens (Pixel):
// x0 ... Ruhelage (Pixel)
  
function position (x0) {
  var arg = (x0-left)*k;                                   // Argument (Bogenma)
  var a = aMax*(type==0 ? Math.cos(arg) : Math.sin(arg));  // Amplitude (Pixel)
  return x0+a*cos;                                         // Rckgabewert  
  } 
  
// Berechnung der momentanen Druckabweichung (Pixel):
// x0 ... Ruhelage (Pixel)
  
function dpPixel (x0) {
  var arg = (x0-left)*k;                                   // Argument (Bogenma)
  var a = aMax*(type==0 ? Math.sin(arg) : -Math.cos(arg)); // Amplitude (Pixel)
  return a*cos;                                            // Rckgabewert
  } 
  
// Umwandlung einer Zahl in eine Zeichenkette:
// n ..... Gegebene Zahl
// d ..... Zahl der Stellen
// fix ... Flag fr Nachkommastellen (im Gegensatz zu gltigen Ziffern)

function ToString (n, d, fix) {
  var s = (fix ? n.toFixed(d) : n.toPrecision(d));         // Zeichenkette mit Dezimalpunkt
  return s.replace(".",decimalSeparator);                  // Eventuell Punkt durch Komma ersetzen
  }
  
// Eingabe einer Zahl:
// ef .... Eingabefeld
// d ..... Zahl der Stellen
// fix ... Flag fr Nachkommastellen (im Gegensatz zu gltigen Ziffern)
// min ... Minimum des erlaubten Bereichs
// max ... Maximum des erlaubten Bereichs
// Rckgabewert: Zahl oder NaN
// Wirkung auf Eingabefeld
  
function inputNumber (ef, d, fix, min, max) {
  var s = ef.value;                                        // Zeichenkette im Eingabefeld
  s = s.replace(",",".");                                  // Eventuell Komma in Punkt umwandeln
  var n = Number(s);                                       // Umwandlung in Zahl, falls mglich
  if (isNaN(n)) n = 0;                                     // Sinnlose Eingaben als 0 interpretieren 
  if (n < min) n = min;                                    // Falls Zahl zu klein, korrigieren
  if (n > max) n = max;                                    // Falls Zahl zu gro, korrigieren
  ef.value = ToString(n,d,fix);                            // Eingabefeld eventuell korrigieren
  return n;                                                // Rckgabewert
  }
   
// Eingabe:
// Seiteneffekt lengthReal

function input () {
  lengthReal = inputNumber(ipl,3,false,0.1,10);            // Reale Wellenlnge (m)
  }
  
//-------------------------------------------------------------------------------------------------

// Neuer Grafikpfad (Standardwerte):

function newPath () {
  ctx.beginPath();                                         // Neuer Pfad
  ctx.strokeStyle = "#000000";                             // Linienfarbe schwarz
  ctx.lineWidth = 1;                                       // Liniendicke 1
  }
  
// Linie zeichnen:
// x1, y1 ... Anfangspunkt
// x2, y2 ... Endpunkt
// c ........ Farbe (optional, Defaultwert schwarz)

function line (x1, y1, x2, y2, c) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  if (c) ctx.strokeStyle = c;                              // Linienfarbe festlegen, falls angegeben
  ctx.moveTo(x1,y1); ctx.lineTo(x2,y2);                    // Linie vorbereiten
  ctx.stroke();                                            // Linie zeichnen
  }
  
// Pfeil zeichnen:
// x1, y1 ... Anfangspunkt
// x2, y2 ... Endpunkt
// w ........ Liniendicke (optional)
// Zu beachten: Die Farbe wird durch ctx.strokeStyle bestimmt.

function arrow (x1, y1, x2, y2, w) {
  if (!w) w = 1;                                           // Falls Liniendicke nicht definiert, Defaultwert                          
  var dx = x2-x1, dy = y2-y1;                              // Vektorkoordinaten
  var length = Math.sqrt(dx*dx+dy*dy);                     // Lnge
  if (length == 0) return;                                 // Abbruch, falls Lnge 0
  dx /= length; dy /= length;                              // Einheitsvektor
  var s = 2.5*w+7.5;                                       // Lnge der Pfeilspitze 
  var xSp = x2-s*dx, ySp = y2-s*dy;                        // Hilfspunkt fr Pfeilspitze         
  var h = 0.5*w+3.5;                                       // Halbe Breite der Pfeilspitze
  var xSp1 = xSp-h*dy, ySp1 = ySp+h*dx;                    // Ecke der Pfeilspitze
  var xSp2 = xSp+h*dy, ySp2 = ySp-h*dx;                    // Ecke der Pfeilspitze
  xSp = x2-0.6*s*dx; ySp = y2-0.6*s*dy;                    // Einspringende Ecke der Pfeilspitze
  ctx.beginPath();                                         // Neuer Pfad
  ctx.lineWidth = w;                                       // Liniendicke
  ctx.moveTo(x1,y1);                                       // Anfangspunkt
  if (length < 5) ctx.lineTo(x2,y2);                       // Falls kurzer Pfeil, weiter zum Endpunkt, ...
  else ctx.lineTo(xSp,ySp);                                // ... sonst weiter zur einspringenden Ecke
  ctx.stroke();                                            // Linie zeichnen
  if (length < 5) return;                                  // Falls kurzer Pfeil, keine Spitze
  ctx.beginPath();                                         // Neuer Pfad fr Pfeilspitze
  ctx.lineWidth = 1;                                       // Liniendicke zurcksetzen
  ctx.fillStyle = ctx.strokeStyle;                         // Fllfarbe wie Linienfarbe
  ctx.moveTo(xSp,ySp);                                     // Anfangspunkt (einspringende Ecke)
  ctx.lineTo(xSp1,ySp1);                                   // Weiter zum Punkt auf einer Seite
  ctx.lineTo(x2,y2);                                       // Weiter zur Spitze
  ctx.lineTo(xSp2,ySp2);                                   // Weiter zum Punkt auf der anderen Seite
  ctx.closePath();                                         // Zurck zum Anfangspunkt
  ctx.fill();                                              // Pfeilspitze zeichnen 
  }
  
// Kreisscheibe mit schwarzem Rand zeichnen:
// (x,y) ... Mittelpunktskoordinaten (Pixel)
// r ....... Radius (Pixel)
// c ....... Fllfarbe (optional)

function circle (x, y, r, c) {
  if (c) ctx.fillStyle = c;                                // Fllfarbe
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.arc(x,y,r,0,2*Math.PI,true);                         // Kreis vorbereiten
  ctx.fill();                                              // Kreis ausfllen
  ctx.stroke();                                            // Rand zeichnen
  }

// Markierungen fr Knoten und Buche zeichnen:
// n ... Nummer der Darstellung (0 fr Rohr, 1 fr Elongation, 2 fr Druckabweichung)
// y ... Hhe (Pixel)

function drawMarks (n, y) {
  ctx.fillStyle = "#000000";                               // Farbe schwarz
  var iMax = Math.round(length/lambda4);                   // Maximaler Index fr Markierungen
  var leftNode = (type >= 1);                              // Flag fr Schwingungsknoten am linken Rand
  if (n == 2) leftNode = !leftNode;                        // Flag fr Druckknoten am linken Rand
  for (var i=0; i<=iMax; i++) {                            // Fr alle Markierungen ...
    var xM = left+i*lambda4;                               // x-Koordinate der Markierung (Pixel)
    line(xM,y-3,xM,y+3);                                   // Kurzer Strich
    if (n == 0) continue;                                  // Falls keine Bezeichnung, weiter zur nchsten Markierung
    var s = symbolNode;                                    // Symbol fr Schwingungs- oder Druckknoten
    if (leftNode && i%2 == 1 || !leftNode && i%2 == 0)     // Falls Bedingung fr Bauch erfllt ...
      s = symbolAntinode;                                  // ... Symbol fr Schwingungs- oder Druckbauch
    ctx.fillText(s,xM-3,y+13);                             // Symbol ausgeben
    } // Ende der for-Schleife
  }
  
// Senkrechte Reihe von Teilchen zeichnen:
// x ...... Gleichgewichtslage (Pixel)
// yMin ... Minimaler Wert der senkrechten Bildschirmkoordinate (Pixel)
// yMax ... Maximaler Wert der senkrechten Bildschirmkoordinate (Pixel)
  
function seriesParticles (x, yMin, yMax) {
  ctx.fillStyle = colorParticle;                           // Farbe fr Teilchen
  var posX = position(x);                                  // Waagrechte Bildschirmkoordinate (Pixel)
  for (var y=yMin; y<=yMax; y+=20) circle(posX,y,2);       // Reihe der Teilchen zeichnen
  }  
  	  
// Rohr mit Teilchen zeichnen:
// Seiteneffekt cos

function drawTube () {
  cos = Math.cos(omega*t);                                 // Hilfsgre cos(omega*t)
  ctx.fillStyle = "#000000";                               // Fllfarbe schwarz
  ctx.fillRect(left,27,length,3);                          // Oberer Rand
  ctx.fillRect(left,90,length,3);                          // Unterer Rand 
  if (type >= 1) ctx.fillRect(left-3,27,3,66);             // Linker Rand
  if (type == 2) ctx.fillRect(left+length,27,3,66);        // Rechter Rand
  drawMarks(0,27);                                         // Markierungen oben 
  drawMarks(0,92);                                         // Markierungen unten
  for (var x=left+10; x<=left+length-10; x+=20)            // Fr die erste, dritte, fnfte Reihe usw. ...              
    seriesParticles(x,40,80);                              // Teilchen zeichnen
  for (x=left; x<=left+length; x+=20)                      // Fr die zweite, vierte, sechste Reihe usw. ...
    seriesParticles(x,50,70);                              // Teilchen zeichnen
  if (yT < 0) return;                                      // Falls kein besonderes Teilchen, abbrechen                            
  var x = position(xT);                                    // Aktuelle Position (Pixel)  
  line(xT,yT,x,yT,colorElongation);                        // Waagrechte Linie fr momentane Auslenkung 
  circle(x,yT,2,colorElongation);                          // Besonderes Teilchen 
  }
  
// Sinuskurve (Nherung durch Polygonzug):
// (x,y) ... Nullpunkt (Pixel)
// per ..... Periode (Pixel)
// ampl .... Amplitude (Pixel)
// xMin .... Minimaler x-Wert (Pixel)
// xMax .... Maximaler x-Wert (Pixel)

function drawSinus (x, y, per, ampl, xMin, xMax) {
  var k = 2*Math.PI/per;                                   // Hilfsgre
  ctx.beginPath();                                         // Neuer Grafikpfad
  ctx.lineWidth = 1;                                       // Liniendicke
  ctx.moveTo(xMin,y-ampl*Math.sin(k*(xMin-x)));            // Anfangspunkt
  for (var xx=xMin+1; xx<=xMax; xx++)                      // Fr alle Teilstrecken ...
    ctx.lineTo(xx,y-ampl*Math.sin(k*(xx-x)));              // Linie hinzufgen
  ctx.stroke();                                            // Polygonzug fr Kurve zeichnen
  }
       
// Diagramm:
// n .... Art des Diagramms (1 fr Elongation, 2 fr Druckabweichung)
// x0 ... x-Wert fr Beginn der Sinuskurve
// y0 ... y-Wert des Ursprungs
  
function drawDiagram (n, x0, y0) {
  var right = left+length;                                 // Rechter Rand (Pixel)
  ctx.strokeStyle = ctx.fillStyle = "#000000";             // Farbe schwarz
  var s = (n==1 ? text12 : text13);                        // berschrift zum Diagramm
  ctx.fillText(s,left+50,y0-55);                           // berschrift ausgeben
  arrow(left-10,y0,right+30,y0);                           // Waagrechte Achse
  ctx.fillText(symbolPosition,right+20,y0+12);             // Beschriftung der waagrechten Achse
  arrow(left,y0+65,left,y0-65);                            // Senkrechte Achse
  s = (n==1?symbolDeltaX:symbolDeltaP);                    // Symbol fr Auslenkung bzw. Druckunterschied
  ctx.fillText(s,left-21,y0-55);                           // Beschriftung der senkrechten Achse
  drawSinus(x0,y0,lambda,aMax,left,right);                 // Kurve fr Extrema          
  drawSinus(x0,y0,lambda,-aMax,left,right);                // Kurve fr entgegengesetzte Extrema
  var c = (n==1 ? colorElongation : colorPressure);        // Farbe des Diagramms
  ctx.strokeStyle = c;                                     // Linienfarbe
  drawSinus(x0,y0,lambda,aMax*cos,left,right);             // Kurve fr momentane Situation
  drawMarks(n,y0);                                         // Markierungen zeichnen        
  if (xT < 0) return;                                      // Falls kein besonderes Teilchen, abbrechen
  var y = y0-(n==1 ? position(xT)-xT : dpPixel(xT));       // Senkrechte Bildschirmkoordinate (Pixel)
  if (n == 1) circle(xT,y,2,c);                            // Falls erstes Diagramm, Markierung fr momentane Auslenkung 
  line(xT,y0,xT,y,c);                                      // Senkrechte Linie zeichnen
  }

// Grafikausgabe:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfllen
  t = (new Date()-t0)/1000;                                // Zeitvariable (s) aktualisieren
  if (xT >= left) line(xT,20,xT,height-20,"#c0c0c0");      // Falls besonderes Teilchen, senkrechte Linie zeichnen
  ctx.font = "normal normal bold 12px sans-serif";         // Zeichensatz
  drawTube();                                              // Rohr mit Teilchen zeichnen
  var x0 = (type==0 ? left-lambda4 : left);                // Hilfsgre fr Sinuskurve
  drawDiagram(1,x0,185);                                   // Diagramm zur Elongation zeichnen
  x0 = (type==0 ? left : left+lambda4);                    // Hilfsgre fr Sinuskurve       
  drawDiagram(2,x0,330);                                   // Diagramm zur Druckabweichung zeichnen
  }
  
document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Start-Methode aufrufen

