/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class N2Gesetz
extends PhApplet
implements Runnable,
ActionListener,
MouseMotionListener {
    final int width0 = 480;
    final int xStart = 40;
    final int length = 200;
    Thread thr;
    Font fC;
    Font fCLarge;
    Canvas1 cv;
    GBLJPanel p;
    JTextField tf1;
    JTextField tf2;
    JTextField tf3;
    JButton bReset;
    JButton bStart;
    JButton bDiagram;
    JTextArea li;
    JScrollPane sp;
    int state;
    boolean diagram;
    double M;
    double m;
    double my;
    final double g = 9.81;
    double a;
    int ls;
    double xLS;
    double tLS;
    double t;
    double x;
    Vector s;

    public void start() {
        super.start();
        this.fC = new Font("Courier", 0, 12);
        this.fCLarge = new Font("Courier", 1, 16);
        this.M = 0.1;
        this.m = 0.001;
        this.my = 0.0;
        this.a = (this.m - this.my * this.M) * 9.81 / (this.M + this.m);
        this.cv = new Canvas1();
        this.cv.setBackground(this.BG);
        this.cv.setBounds(0, 0, 480, this.height);
        this.cp.add(this.cv);
        this.p = new GBLJPanel(this.PAN);
        this.p.setBounds(480, 0, this.width - 480, this.height);
        this.bReset = new JButton(this.text(2));
        this.p.add((JComponent)this.bReset, Color.cyan, 0, 0, 3, 5, 10, 0, 10);
        this.bStart = new JButton(this.text(3));
        this.p.add((JComponent)this.bStart, Color.yellow, 0, 1, 3, 10, 10, 5, 10);
        this.bDiagram = new JButton(this.text(5));
        this.p.add((JComponent)this.bDiagram, Color.white, 0, 2, 3, 5, 10, 5, 10);
        this.p.add((JComponent)new JLabel(this.text(6)), this.PAN, 0, 3, 3, 5, 10, 0, 10);
        this.p.add((JComponent)new JLabel("M = "), this.PAN, this.fC, 0, 4, 1, 0, 10, 5, 0);
        this.tf1 = new JTextField(4);
        this.p.add((JComponent)this.tf1, Color.white, this.fC, 1, 4, 1, 0, 0, 5, 0);
        this.p.add((JComponent)new JLabel("g"), this.PAN, this.fC, 2, 4, 1, 0, 5, 5, 10);
        this.p.add((JComponent)new JLabel(this.text(7)), this.PAN, 0, 5, 3, 5, 10, 0, 10);
        this.p.add((JComponent)new JLabel("m = "), this.PAN, this.fC, 0, 6, 1, 0, 10, 5, 0);
        this.tf2 = new JTextField(5);
        this.p.add((JComponent)this.tf2, Color.white, this.fC, 1, 6, 1, 0, 0, 5, 0);
        this.p.add((JComponent)new JLabel("g"), this.PAN, this.fC, 2, 6, 1, 0, 5, 5, 10);
        this.p.add((JComponent)new JLabel(this.text(8)), this.PAN, 0, 7, 3, 5, 10, 0, 10);
        this.p.add((JComponent)new JLabel("\u00b5 = "), this.PAN, this.fC, 0, 8, 1, 0, 10, 5, 0);
        this.tf3 = new JTextField(6);
        this.p.add((JComponent)this.tf3, Color.white, this.fC, 1, 8, 1, 0, 0, 5, 0);
        this.p.add((JComponent)new JLabel(this.text(9)), this.PAN, 0, 9, 3, 5, 10, 0, 10);
        this.li = new JTextArea(3, 20);
        this.li.append("s         t         \n");
        this.li.append("--------  --------  \n");
        this.li.setEditable(false);
        this.li.setFont(this.fC);
        this.sp = new JScrollPane(this.li);
        this.sp.setPreferredSize(new Dimension(100, 36));
        this.sp.setHorizontalScrollBarPolicy(31);
        this.sp.setVerticalScrollBarPolicy(22);
        this.p.add((JComponent)this.sp, Color.white, this.fC, 0, 10, 3, 0, 10, 5, 10);
        this.p.add((JComponent)new JLabel(this.text(14)), this.PAN, 0, 11, 3, 5, 10, 0, 10);
        this.p.add((JComponent)new JLabel(this.text(15)), this.PAN, 0, 12, 3, 0, 10, 10, 10);
        this.cp.add((Component)this.p);
        this.p.repaint();
        this.bStart.addActionListener(this);
        this.bDiagram.addActionListener(this);
        this.bReset.addActionListener(this);
        this.tf1.addActionListener(this);
        this.tf2.addActionListener(this);
        this.tf3.addActionListener(this);
        this.cv.addMouseMotionListener(this);
        this.updateTF();
        this.newSeries();
        this.bDiagram.setEnabled(false);
        this.bReset.setEnabled(false);
        this.thr = new Thread(this);
        this.thr.start();
    }

    public void stop() {
        this.thr = null;
        this.cp.removeAll();
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.p.repaint();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l2 = System.currentTimeMillis();
            if (this.state > 0) {
                this.t += (double)(l2 - l) / 1000.0;
            }
            l = l2;
        }
    }

    void updateTF() {
        this.tf1.setText(this.toString(this.M * 1000.0, 0));
        this.tf2.setText(this.toString(this.m * 1000.0, 1));
        this.tf3.setText(this.toString(this.my, 3));
    }

    String stringVal(double d, int n, String string) {
        String string2 = this.toString(d, n);
        return string2 + " " + string;
    }

    void diagram(Graphics graphics, int n, int n2) {
        double d;
        double d2;
        int n3;
        int n4;
        int n5;
        graphics.setColor(Color.black);
        graphics.setFont(this.fC);
        graphics.drawLine(n - 10, n2, n + 130, n2);
        graphics.drawLine(n + 120, n2 - 3, n + 130, n2);
        graphics.drawLine(n + 120, n2 + 3, n + 130, n2);
        for (n5 = 1; n5 <= 5; ++n5) {
            graphics.drawLine(n + n5 * 20, n2 - 3, n + n5 * 20, n2 + 3);
            graphics.drawString("" + n5, n + n5 * 20 - 3, n2 + 15);
        }
        graphics.drawLine(n, n2 + 10, n, n2 - 230);
        graphics.drawLine(n - 3, n2 - 220, n, n2 - 230);
        graphics.drawLine(n + 3, n2 - 220, n, n2 - 230);
        for (n5 = 1; n5 <= 10; ++n5) {
            graphics.drawLine(n - 3, n2 - n5 * 20, n + 3, n2 - n5 * 20);
            graphics.drawString(this.toString((double)n5 / 10.0, 1), n - 25, n2 - n5 * 20 + 5);
        }
        if (this.diagram) {
            int n6;
            int n7;
            n4 = n7 = n;
            n3 = n6 = n2;
            while (n7 < n + 140 && n6 > n2 - 220) {
                n4 = n7;
                n3 = n6;
                n7 = n4 + 2;
                d2 = (double)(n7 - n) / 20.0;
                d = this.a / 2.0 * d2 * d2;
                n6 = (int)Math.round((double)n2 - d * 200.0);
                graphics.drawLine(n4, n3, n7, n6);
            }
        }
        for (n5 = 0; n5 < this.s.size(); ++n5) {
            Double d3 = (Double)this.s.elementAt(n5);
            d = d3;
            d2 = Math.sqrt(2.0 * d / this.a);
            n4 = (int)Math.round((double)n + d2 * 20.0);
            n3 = (int)Math.round((double)n2 - d * 200.0);
            graphics.fillRect(n4 - 2, n3 - 2, 5, 5);
        }
        if (this.state >= 2) {
            n4 = (int)Math.round((double)n + this.tLS * 20.0);
            n3 = (int)Math.round((double)n2 - this.xLS * 200.0);
            graphics.fillRect(n4 - 2, n3 - 2, 5, 5);
        }
        graphics.setColor(Color.red);
        d2 = Math.min(this.t, Math.sqrt(2.0 / this.a));
        n4 = (int)Math.round((double)n + d2 * 20.0);
        d = this.a / 2.0 * d2 * d2;
        n3 = (int)Math.round((double)n2 - d * 200.0);
        graphics.fillOval(n4 - 2, n3 - 2, 5, 5);
        graphics.setFont(HELV);
        graphics.setColor(Color.black);
        graphics.drawString("t", n + 125, n2 + 15);
        graphics.drawString(this.text(11), n + 113, n2 + 30);
        graphics.drawString("s", n - 20, n2 - 225);
        graphics.drawString(this.text(12), n - 37, n2 - 210);
    }

    void calculation() {
        this.M = this.inputTF(this.tf1, 0.0, 1000.0, 0) / 1000.0;
        this.m = this.inputTF(this.tf2, 0.0, 100.0, 1) / 1000.0;
        this.my = this.inputTF(this.tf3, 0.0, 1.0, 3);
        this.a = this.M + this.m > 0.0 ? (this.m - this.my * this.M) * 9.81 / (this.M + this.m) : 0.0;
        if (this.a < 0.0) {
            this.a = 0.0;
            this.enableTextFields(true);
        }
        this.setST();
    }

    void newSeries() {
        this.s = new Vector();
        this.state = 0;
        this.diagram = false;
        this.t = 0.0;
        this.bStart.setText(this.text(3));
        this.bStart.setEnabled(true);
        this.bDiagram.setEnabled(false);
        this.bReset.setEnabled(true);
        this.ls = 140;
        this.calculation();
    }

    void updateList() {
        this.li.append(this.stringVal(this.xLS, 3, "m") + ";    " + this.stringVal(this.tLS, 3, "s\n"));
    }

    void enableTextFields(boolean bl) {
        this.tf1.setEnabled(bl);
        this.tf2.setEnabled(bl);
        this.tf3.setEnabled(bl);
    }

    void actionEnd(Object object) {
        if (object == this.bReset) {
            this.li.setText("");
            this.li.append("s         t         \n");
            this.li.append("--------  --------  \n");
        }
        if (object == this.bStart && this.state >= 2) {
            this.updateList();
            this.state = 0;
        }
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMaximum());
        this.p.repaint();
    }

    void setST() {
        this.xLS = (double)(this.ls - 40) / 200.0;
        this.tLS = Math.sqrt(2.0 * this.xLS / this.a);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.bReset.setEnabled(true);
        Object object = actionEvent.getSource();
        if (object == this.bReset) {
            this.newSeries();
            this.enableTextFields(true);
        } else if (object == this.bStart && this.state == 0) {
            this.bStart.setEnabled(false);
            this.enableTextFields(false);
            this.t = 0.0;
            this.state = 1;
            this.calculation();
        } else if (object == this.bStart && this.state >= 2) {
            this.bDiagram.setEnabled(this.s.size() >= 4);
            this.bStart.setText(this.text(3));
            this.s.addElement(new Double(this.xLS));
            this.t = 0.0;
            this.state = 0;
            this.updateList();
        } else if (object == this.bDiagram) {
            this.diagram = true;
        } else if (object instanceof JTextField) {
            this.newSeries();
        }
        this.actionEnd(object);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.state != 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.ls - 40 || n > this.ls + 40 || n2 < 10 || n2 > 90) {
            return;
        }
        this.ls = Math.min(n, 240);
        this.ls = Math.max(this.ls, 50);
        this.setST();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class Canvas1
    extends JPanel {
        Canvas1() {
        }

        void wagon(Graphics graphics) {
            int n = 240;
            int n2 = (int)Math.round(N2Gesetz.this.x * 200.0);
            int n3 = (int)Math.round(N2Gesetz.this.t * 20.0);
            graphics.setColor(Color.blue);
            graphics.fillRect(40 + n2 - 40, 50, 40, 20);
            graphics.drawLine(40 + n2, 58, n + 10, 58);
            graphics.drawArc(n - 2, 58, 22, 22, 0, 90);
            graphics.drawLine(n + 20, 68, n + 20, 100 + n2);
            graphics.fillRect(n + 20 - 2, 100 + n2, 5, 6);
            graphics.setColor(Color.red);
            graphics.fillOval(40 + n2 - 2, 56, 5, 5);
        }

        void clock(Graphics graphics) {
            graphics.setColor(Color.gray);
            graphics.fillRect(90, 150, 100, 30);
            graphics.setColor(Color.black);
            graphics.fillRect(100, 155, 80, 20);
            graphics.setColor(Color.red);
            graphics.setFont(N2Gesetz.this.fCLarge);
            graphics.drawString(N2Gesetz.this.stringVal(N2Gesetz.this.t < N2Gesetz.this.tLS ? N2Gesetz.this.t : N2Gesetz.this.tLS, 3, "s"), 106, 170);
        }

        void writeValues(Graphics graphics) {
            graphics.setFont(WFApplet.HELV);
            graphics.setColor(Color.black);
            String string = "s = " + N2Gesetz.this.stringVal(N2Gesetz.this.xLS, 3, "m");
            graphics.drawString(string, 100, 260);
            string = "t = ";
            if (N2Gesetz.this.state >= 2) {
                string = string + N2Gesetz.this.stringVal(N2Gesetz.this.tLS, 3, "s");
            }
            graphics.drawString(string, 100, 280);
            string = "a =  ";
            graphics.drawString(string, 100, 300);
            FontMetrics fontMetrics = this.getFontMetrics(WFApplet.HELV);
            int n = fontMetrics.stringWidth(string);
            graphics.fillRect(100 + n, 295, 21, 2);
            int n2 = fontMetrics.stringWidth("2s");
            graphics.drawString("2s", 100 + n + 10 - n2 / 2, 293);
            n2 = fontMetrics.stringWidth("t\u00b2");
            graphics.drawString("t\u00b2", 100 + n + 10 - n2 / 2, 308);
            if (N2Gesetz.this.state <= 1) {
                return;
            }
            string = "  = " + N2Gesetz.this.stringVal(N2Gesetz.this.a, 3, "m/s\u00b2");
            graphics.drawString(string, 100 + n + 20, 300);
        }

        public void paint(Graphics graphics) {
            if (N2Gesetz.this.state == 1 && N2Gesetz.this.x > N2Gesetz.this.xLS) {
                N2Gesetz.this.state = 2;
                N2Gesetz.this.bStart.setText(N2Gesetz.this.text(4));
                N2Gesetz.this.bStart.setEnabled(true);
            }
            if (N2Gesetz.this.state <= 2 && N2Gesetz.this.x > 1.0) {
                N2Gesetz.this.state = 3;
            }
            switch (N2Gesetz.this.state) {
                case 0: {
                    N2Gesetz.this.x = 0.0;
                    break;
                }
                case 1: 
                case 2: {
                    N2Gesetz.this.x = N2Gesetz.this.a / 2.0 * N2Gesetz.this.t * N2Gesetz.this.t;
                    break;
                }
                case 3: {
                    N2Gesetz.this.x = 1.0;
                }
            }
            graphics.setFont(N2Gesetz.this.fC);
            super.paint(graphics);
            graphics.setColor(Color.orange);
            graphics.fillRect(0, 60, 250, 20);
            graphics.fillOval(240, 60, 20, 20);
            graphics.setColor(Color.black);
            graphics.drawLine(0, 60, 0, 80);
            graphics.drawLine(0, 60, 250, 60);
            graphics.drawLine(0, 80, 250, 80);
            graphics.drawArc(240, 60, 20, 20, 270, 180);
            graphics.setColor(Color.red);
            graphics.fillRect(240, 55, 6, 15);
            for (int i = 0; i < 10; ++i) {
                if (i % 2 == 0) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.green);
                }
                graphics.fillRect(40 + i * 20, 85, 20, 10);
                graphics.setColor(Color.black);
                graphics.drawRect(40, 85, 200, 10);
            }
            this.wagon(graphics);
            this.clock(graphics);
            N2Gesetz.this.diagram(graphics, 310, 300);
            this.writeValues(graphics);
            graphics.drawString(N2Gesetz.this.text(10), N2Gesetz.this.ls + 10, 50);
            graphics.setFont(N2Gesetz.this.fC);
            graphics.fillRect(N2Gesetz.this.ls - 3, 40, 7, 20);
            graphics.drawLine(N2Gesetz.this.ls - 20, 30, N2Gesetz.this.ls + 20, 30);
            if (N2Gesetz.this.ls > 50) {
                graphics.drawLine(N2Gesetz.this.ls - 10, 27, N2Gesetz.this.ls - 20, 30);
                graphics.drawLine(N2Gesetz.this.ls - 10, 33, N2Gesetz.this.ls - 20, 30);
            }
            if (N2Gesetz.this.ls < 240) {
                graphics.drawLine(N2Gesetz.this.ls + 10, 27, N2Gesetz.this.ls + 20, 30);
                graphics.drawLine(N2Gesetz.this.ls + 10, 33, N2Gesetz.this.ls + 20, 30);
            }
            if (N2Gesetz.this.my * N2Gesetz.this.M >= N2Gesetz.this.m) {
                graphics.setColor(Color.red);
                graphics.setFont(WFApplet.HELV);
                graphics.drawString(N2Gesetz.this.text(13), 80, 120);
            }
        }
    }
}

