<?php

use block_ned_student_menu\shared_lib as SH;

require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

$cmid = required_param('id', PARAM_INT);  // activity ID.
$userid = $USER->id;

$url = SH::url('~/ask_to_resubmit.php', ['id' => $cmid]);
$name = SH::str('ask_to_resubmit');
$PAGE->set_url($url);
$PAGE->navbar->add($name, $url);

list ($course, $cm) = SH::get_course_and_cm_from_cmid($cmid, 'assign');
require_login($course, false, $cm);
$context = context_module::instance($cm->id);
require_capability('mod/assign:view', $context);
require_capability('mod/assignment:submit', $context);

$PAGE->add_body_class('path-blocks-NED');
$PAGE->set_title($name);
$PAGE->set_heading($name);

$tt_config = block_ned_student_menu_get_teacher_tools_block_config($course->id);

$check_for_errors = function() use(&$course, &$cm, &$USER, &$cmid, &$tt_config){
    $userid = $USER->id;

    if (!$tt_config->enableresubmissions || empty($tt_config->resubmission_assignments) ||
        !isset($tt_config->resubmission_assignments[$cmid]) || !$tt_config->resubmission_assignments[$cmid]){
        return 'ask_to_resubmit:error:is_off';
    }

    $submission_info = new SH::$assign_info($cm, $userid);

    if (!$submission_info || !$submission_info->exist){
        return 'ask_to_resubmit:error:no_records';
    }

    if ($submission_info->assign->get_instance()->teamsubmission) {
        $oldsubmission = $submission_info->assign->get_group_submission($userid, 0, false);
    } else {
        $oldsubmission = $submission_info->assign->get_user_submission($userid, false);
    }

    if (!$oldsubmission) {
        return 'ask_to_resubmit:error:no_records';
    }

    if (!$submission_info->last_grade_time){
        return 'ask_to_resubmit:error:not_graded';
    }

    if ($tt_config->daysforresubmission &&
        (time() >= ($submission_info->last_grade_time + $tt_config->daysforresubmission * DAYSECS))){
        return 'ask_to_resubmit:error:time_is_over';
    }

    $submissions_count = SH::$assign_info::get_course_submissions_count($course->id, $userid, $tt_config);
    if ($tt_config->maximumattemptsincourse && $tt_config->maximumattemptsincourse <= $submissions_count){
        return SH::str('resubmit_course_attempts_error', [$submissions_count, $tt_config->maximumattemptsincourse]);
    }

    if ($tt_config->maximumattempts && $tt_config->maximumattempts <= $submission_info->user_signed_submissions_count){
        return SH::str('resubmit_attempts_error', [$submission_info->user_signed_submissions_count, $tt_config->maximumattempts]);
    }

    // resubmissioncriteria: 0 - if none, 1 - if need check participation_power
    if ($tt_config->resubmissioncriteria){
        $user_status = new \block_ned_student_menu\activity_status();
        $user_status->check_activities_by_course($course, $USER, true);
        $participation_power = $user_status->get_participation_power();
        if ($participation_power < $tt_config->participationpowerrequired){
            return SH::str('resubmit_pp_error', [$participation_power, $tt_config->participationpowerrequired]);
        }
    }

    return false;
};

$error = $check_for_errors();
if ($error){
    echo $OUTPUT->header();
    echo \html_writer::div(SH::str('ask_to_resubmit:error', $cm->name) . "<br>" . SH::str_check($error),
        'errorbox alert alert-danger');
    throw new moodle_exception('generalexceptionmessage', 'error', '', SH::str('pluginname'));
} else {
    $ned_assign = SH::$ned_assign::get_assign_by_cm($cm);
    $new_due_date = $tt_config->daysforresubmission ? (time() + $tt_config->daysforresubmission * DAYSECS) : 0;
    $ned_assign->force_add_attempt($userid, $userid, $new_due_date);
    SH::redirect(new moodle_url(SH::$ned_assign::MOODLE_URL, ['id' => $cmid]));
}
