<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * UTILS
 *
 * @package block_ned_student_menu
 * @copyright 2019 Michael Gardener
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 */

namespace block_ned_student_menu;

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->dirroot.'/blocks/ned_student_menu/lib.php');

class utils {
    public static function kica_gradebook_enabled($courseid=0) {
        if ($courseid){
            $kica = get_kica_if_exists($courseid);
            return $kica->enabled ?? false;
        } else {
            return is_kica_exists();
        }
    }
}