<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_student_menu
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_student_menu as NED;

defined('MOODLE_INTERNAL') || die();
require_once(dirname(__FILE__) . '/../../config.php');

/**
 * Simple FN_TABS block config form class
 *
 * @copyright 2011 MoodleFN
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

class block_ned_student_menu_edit_form extends block_edit_form {

    /**
     * @param MoodleQuickForm $mform - quickform object definition
     */
    protected function specific_definition($mform) {
        $config = get_config(NED\PLUGIN_NAME);

        $check_vars = function($name, $visiblename, $defaultsetting, $defdef='') use ($config) {
            $visiblename = NED\str(empty($visiblename) ? $name : $visiblename);
            $defaultsetting = is_null($defaultsetting) ? ($config->$name ?? $defdef) : $defaultsetting;
            $name = 'config_' . $name;
            return [$name, $visiblename, $defaultsetting];
        };

        $configheading = function($name, $heading='') use ($mform){
            $heading = $heading ?: $name;
            $mform->addElement('header', $name, NED\str($heading));
        };
        $configyesno = function($name, $visiblename='', $defaultsetting=null, $attrib = []) use ($mform, $check_vars){
            list($name, $visiblename, $defaultsetting) = $check_vars($name, $visiblename, $defaultsetting, 0);
            $mform->addElement('selectyesno', $name, $visiblename, $attrib);
            $mform->setDefault($name, $defaultsetting);
        };

        // Section header title according to language file.
        $mform->addElement('header', 'configheader', NED\str('generalsettings'));

        $pluginname = $config->blocktitlesitelevel ?: NED\str('blocktitle');
        $mform->addElement('text', 'config_block_title', NED\str('block_title'));
        $mform->setType('config_block_title', PARAM_TEXT);
        $mform->setDefault('config_block_title', $pluginname);

        $mform->addElement('static', 'blockinfo', NED\str('blockinfo'),
            '<a target="_blank" href="http://ned.ca/student-menu">http://ned.ca/student-menu</a>');

        $settingurl = new moodle_url('/admin/settings.php', array('section' => 'blocksettingned_student_menu'));
        $mform->addElement('static', 'blocksettings', NED\str('blocksitesettings'),
            html_writer::link($settingurl, NED\str('opensitesettingspage'),
                array('target' => '_blank')
            )
        );

        $yesno = array(
            0 => get_string('no'),
            1 => get_string('yes')
        );
        $showhideoptions = array(
            '1' => NED\str('show'),
            '0' => NED\str('hide')
        );

        // My Progress.
        $mform->addElement('header', 'customlinks',
            NED\str('myprogress'));

        $mform->addElement('select', 'config_showcompleted', NED\str('completed'), $showhideoptions);
        $mform->setDefault('config_showcompleted', 1);

        $mform->addElement('select', 'config_shownotattempted', NED\str('notattempted'), $showhideoptions);
        $mform->setDefault('config_shownotattempted', 1);

        $mform->addElement('select', 'config_showwaitingforgrade', NED\str('waitingforgrade'), $showhideoptions);
        $mform->setDefault('config_showwaitingforgrade', 1);

        $mform->addElement('select', 'config_showdraft',
            NED\str('showdraft'), $yesno);
        $mform->setDefault('config_showdraft', 1);

        // Student Progress
        $configheading('confstudentprogress');

        $configyesno('showgeneralinfosection','', 1);
        $configyesno('showsummativeactivitiessection','', 1);
        $configyesno('showformativeactivitiessection','', 1);
        $configyesno('showformativesummativeicons','', 1);
        $configyesno('showduedatecolumn','', 1);
        $configyesno('showtagsfilter','', 1);

        // Custom links.
        $mform->addElement('header', 'customlinks',
            NED\str('customlinks'));

        $mform->addElement('textarea', 'config_customlinks', '', 'wrap="virtual" rows="10" cols="100"');
        $mform->addElement('static', 'config_customlinks_desc', '', NED\str('customlinksconfigdesc'));

        // Site links.
        $mform->addElement('html', html_writer::div('Site links', 'ned_controller_configsubtitle'));
        if ($numberoflinks = $config->numberoflinks ?? 0) {
            for ($i = 1; $i <= $numberoflinks; $i++) {
                $sitelinkgroup=array();
                $sitelinkgroup[] = $mform->createElement('select', 'config_sitelink_'.$i, '', $showhideoptions);
//                $customlink =
                $sitelinkgroup[] = $mform->createElement('static', 'config_sitelink_title_'.$i, '',
                    '<div class="local_ned_controller_menu_sitelink-title">'.$config->{'customlinkstitle_' . $i}.'</div>');
                $mform->addGroup($sitelinkgroup, 'sitelinkgroup'.$i, '', array(' '), false);
                $mform->setDefault('config_sitelink_'.$i, 1);
            }
        }
    }
}