<?php

use block_ned_student_menu as NED;
use local_ned_controller\assign_info;

require_once('../../config.php');
require_once (__DIR__ .'/lib.php');

$cmid = required_param('cmid', PARAM_INT);
$userid = optional_param('userid', 0, PARAM_INT);

require_login();
list ($course, $cm) = get_course_and_cm_from_cmid($cmid, 'assign');
$context = context_course::instance($course->id);

if (NED\is_SM){
    if (!has_capability('mod/assignment:submit', $context)) {
        print_error('Permission error!');
    }
    $userid = $USER->id;
} elseif (NED\is_aTT) {
    if (!has_capability('moodle/grade:viewall', $context)) {
        print_error('Permission error!');
    }
} else {
    print_error('Permission error!');
}

$error_text = '';
while (true){
    $submission_info = new assign_info($cm, $userid);
    if (!$submission_info->exist || $submission_info->submissions_count < 2){
        $error_text = '1';
        break;
    }
    $rm_config = NED\get_rm_config_by_courseid($course->id);
    if (!$rm_config || !isset($rm_config->assignments[$cmid]) || !$rm_config->assignments[$cmid]){
        $error_text = '2';
        break;
    }
    if (($submission_info->last_grade_time && !$submission_info->overriden) || $submission_info->last_submit_time){
        $error_text= '3';
        break;
    }
    if (!NED\remove_last_submission($cmid, $userid, ASSIGN_SUBMISSION_STATUS_REOPENED)){
        $error_text= '4';
        break;
    }

    redirect(
        new moodle_url(NED\PLUGIN_URL . 'student_progress.php',
            ['courseid' => $course->id, 'user' => $userid, 'prevpage' => 'student_progress']),
        NED\str('unusedresubmissions_removed_successfully_one', ['activity' => $cm->name]),
        null,\core\output\notification::NOTIFY_SUCCESS);
    die;
}

print_error('Error: ' . $error_text);
